<?php
define('MPWEB_HOME', get_option('home'));
define('THEME_NAME', 'Blue MANDATORY Theme');
define('CHILD_TEMPLATE_DIR', get_stylesheet_directory_uri());
define('CHILD_TEMPLATE_DIR_IMAGES', CHILD_TEMPLATE_DIR.'/images');
define('CHILD_TEMPLATE_DIR_SCRIPTS', CHILD_TEMPLATE_DIR.'/scripts');
define("CHILD_TEMPLATE_DIR_TEMPLATES", dirname(__FILE__).'/templates');
define("CHILD_THEME_PREFIX", "mandatory");
if(!class_exists('MANDATORY')):
class MANDATORY 
{

	var $theme_mp_banner                       = 'cpc_mp_banner';
	var $theme_mp_banner_extras                = 'cpc_mp_banner_extras';
	var $theme_mp_bannerbg                     = 'cpc_mp_bannerbg';
	var $theme_mp_footer_menu                  = 'cpc_mp_footer_menu';
	var $theme_mp_contact_form                 = 'cpc_mp_contact_form';
	var $theme_mp_contact_form_notification    = 'cpc_mp_contact_form_notification';
	var $theme_mp_email_signup_form_db_version = 'cpc_mp_email_signup_form_db_version';
	var $theme_mp_email_signup_form            = 'cpc_mp_email_signup_form';
	var $theme_mp_email_form_notification      = 'cpc_mp_email_form_notification';
	var $theme_mp_feature_slider               = 'cpc_mp_feature_slider';
	var $theme_mp_social_tools                 = 'cpc_mp_social_tools';
	var $theme_mp_getting_started              = 'cpc_mp_getting_started';
	var $theme_mp_googleanalytics              = 'cpc_mp_googleanalytics';
	var $theme_mp_general_config               = 'cpc_mp_general_config';
	var $theme_mp_hot_topics                   = 'cpc_mp_hot_topics';
	var $theme_mp_photo_gallery_config         = 'cpc_mp_photo_gallery_config';
	var $theme_mp_splash_page_settings         = 'cpc_mp_splash_page_settings';
	var $theme_mp_splash_page                  = 'cpc_mp_splash_page';
	var $theme_mp_splash_page_theme_settings   = 'cpc_mp_splash_page_theme_settings';
	var $categories                            = array('cta'=>'cta', 'events'=>'events', 'feature-article'=>'feature-article', 'feature-video'=>'feature-video', 'media-release'=>'media-release', 'news-riding'=>'news-riding', 'news-government'=>'news-government', 'op-ed'=>'op-ed', 'press-release'=>'press-release', 'speeches'=>'speeches', 'subfeature'=>'subfeature', 'homepage'=>'homepage');

	public function __construct( ) 
	{
		//do something
	}
	
	public function sidebar_widgets( ) 
	{

		if (function_exists('register_sidebar')) {
			register_sidebar(array(
				'name'=>'This is your Sidebar', 'id'=>'sidebar-1', 'description' => __('This Sidebar appears on the right hand side of the website.'), 'before_widget' => '<aside class="widget bg">', 'after_widget' => '</aside>', 'before_title' => '<header><h1>', 'after_title' => '</h1></header><hr>'
			));
			register_sidebar(array(
				'name'=>'This is your Footer area', 'id'=>'footer_sidebar', 'description' => __('Widgets that you place here will appear in the footer area of the website. We highly recommend only adding a maximum of three widgets.'), 'before_widget' => '<aside class="col-md-4 widget bg">', 'after_widget' => '</aside>', 'before_title' => '<header><h1>', 'after_title' => '</h1></header><hr>'
			));
		}
	}

	/*
	 *	@func 	footer
	 * 	@desc 	MANDATORY Footer JS functions. Splash page functions as well.
	 */
	public function footer( )
	{
		?>
		<script type="text/javascript">
		jQuery=jQuery.noConflict();
		jQuery(document).ready(function() {
			jQuery(".fancybox").fancybox();
			
			<?php if (is_page_template('template-splash.php')) { ?>
				var type = jQuery.cookie('mpwp_splash_<?php echo $theme_settings['splash_theme']; ?>');
				
				if (!type){
					// check if cookie exists
					jQuery('.modal').modal('show');
				};
					
				jQuery('.continue_to').on('click', function(e){
					e.preventDefault();
					var d = new Date(),
						dd = d.getDate(),
						mm = d.getMonth()+1,
						yyyy = d.getFullYear();
					if(dd<10){dd='0'+dd} if(mm<10){mm='0'+mm} 
					d = mm+'/'+dd+'/'+yyyy;
					<?php $theme_settings = get_option($this->theme_mp_splash_page_theme_settings); ?>
					var type = jQuery.cookie('mpwp_splash_<?php echo $theme_settings['splash_theme']; ?>');
					if ( type )
						type = type.split('#');
					
					if ( jQuery.isArray(type) && type[0] >= 1 ) {
						jQuery.cookie('mpwp_splash_<?php echo $theme_settings['splash_theme']; ?>', 2+'#'+d, { expires: 90 });
					} else { 
						jQuery.cookie('mpwp_splash_<?php echo $theme_settings['splash_theme']; ?>', 1+'#'+d, { expires: 7 });
					}
					enter_site();
				});
				jQuery('#splash_fullname').blur(function() {
					validate_name(jQuery(this));
				});
				jQuery('#splash_email').blur(function(){
					validate_email(jQuery(this));
				});
				jQuery('#splash_postalcode').blur(function(){
					validate_postalcode(jQuery(this));
				});
				jQuery('.btn-splash').on('click',function(e){
					e.preventDefault();
					var button_data = jQuery(this).data(),
						fullname = jQuery('#splash_fullname'),
						email = jQuery('#splash_email'),
						postalcode = jQuery('#splash_postalcode'),
						pid = <?php echo the_ID(); ?>,
						type= jQuery('#splash_type'),
						button = jQuery(this);
					if(fullname.val() && email.val() && postalcode.val()) {
						button.html(button_data.loading).addClass('disabled');
						var splash = "x=splash_signup&lang=<?php echo q8_translate("en","fr") ;?>&fullname="+ fullname.val() +"&email="+ email.val() +"&postalcode="+ postalcode.val() +"&pid="+ pid +"&splash_type=" + type.val();
						jQuery.ajax({
							url: "<?php echo MPWEB_TEMPLATE_DIR;?>/ajax_updates.php",
							type: "GET",
							dataType: "json",
							data: splash,
							cache: false,
							success: function(data){
								if(data.success){
									fullname.val('');
									email.val('');
									postalcode.val('');
									jQuery('.alert-splash').removeClass('alert-danger').addClass('alert-success').html(data.message).fadeIn();
									var d = new Date(),
									dd = d.getDate(),
									mm = d.getMonth()+1,
									yyyy = d.getFullYear();
									if(dd<10){dd='0'+dd} if(mm<10){mm='0'+mm} 
									d = mm+'/'+dd+'/'+yyyy;
									jQuery.cookie('mpwp_splash_form', 1+'#'+d, { expires: 90 });
										
									setTimeout(function(){enter_site()},3000);
								} else {
									jQuery('.alert-splash').removeClass('alert-success').addClass('alert-danger').html(data.message).fadeIn();
									button.html(button_data.text).removeClass('disabled');
								}
							}
						});
					} else {
						validate_name(fullname);
						validate_email(email);
						validate_postalcode(postalcode);
						jQuery('.alert-splash').removeClass('alert-success').addClass('alert-danger').html('<p><?php echo @q8_translate("Please ensure all required fields are filled out correctly","Veuillez vous assurer de remplir tous les champs requis"); ?></p>').fadeIn();	
					}
				});
			<?php } ?>	
			jQuery('.btn-navbar').on('click',function(){jQuery('#main_nav').toggle();});
		});
		<?php if (is_page_template('template-splash.php')) { ?>
		function validate_name(a){
			if(!a.val()){ a.addClass('input-danger'); } else { a.removeClass('input-danger'); }
		}
		function validate_email(a){
			if(!a.val().match('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$')){ a.addClass('input-danger'); } else { a.removeClass('input-danger'); }
		}
		function validate_postalcode(a) {
			if(!a.val().match('^[a-zA-Z][0-9][a-zA-Z] *[0-9][a-zA-Z][0-9]$')){ a.addClass('input-danger');	} else { a.removeClass('input-danger'); }	
		}
		function enter_site(){
			jQuery('.modal').modal('hide');
			jwplayer('mediaplayer2').stop();
		}
		<?php } ?>
		
		</script>
        <?php
	}

	public function wp_enqueue_scripts( ) 
	{
		
		if (!is_admin()) { 
		}
		wp_enqueue_script('jwplayer', CHILD_TEMPLATE_DIR_SCRIPTS.'/jwplayer/jwplayer.js', array('jquery'));
		if(is_front_page()){
			wp_enqueue_script('flexslider-min', CHILD_TEMPLATE_DIR_SCRIPTS.'/flexslider/jquery.flexslider-min.js', array('jquery'));
			wp_enqueue_script('flexinitialize', CHILD_TEMPLATE_DIR_SCRIPTS.'/flexslider/flexinitialize.js', array('jquery'), null, true);
		}
		//Loaded in footer
		wp_enqueue_script('bootstrap', 'http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js', array('jquery'),null,true);
		wp_enqueue_script('fancybox-pack', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox.pack.js?v=2.1.5', array('jquery'), null, true);
		wp_enqueue_script('fancybox-thumbs', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox-thumbs.js?v=1.0.7', array('jquery'), null, true);
		wp_enqueue_script('fancybox-buttons', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox-buttons.js?v=1.0.5', array('jquery'), null, true);
		wp_enqueue_script('fancybox-media', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox-media.js?v=1.0.6', array('jquery'), null, true);
	}

	public function wp_enqueue_styles( ) 
	{
		if(is_front_page()){
			wp_enqueue_style('flexslider', CHILD_TEMPLATE_DIR_SCRIPTS.'/flexslider/flexslider.css');
		}
		wp_enqueue_style('gfontLato', 'http://fonts.googleapis.com/css?family=Lato:100,300,400,700,900,300italic,700italic');
		wp_enqueue_style('bootstrapstyle', 'http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css');
		wp_enqueue_style('fancyBox', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox.css?v=2.1.5');
		wp_enqueue_style('fancyBoxHelper', CHILD_TEMPLATE_DIR_SCRIPTS.'/fancybox/jquery.fancybox-thumbs.css?v=1.0.7');
		wp_enqueue_style('mainstyles', CHILD_TEMPLATE_DIR.'/style.css');
	}
}
$MANDATORY = new MANDATORY();
global $MANDATORY;
else : exit("Class 'MANDATORY' already exists"); endif;

if ( isset( $MANDATORY ) && defined( "Q8_CORE_ACTIVE_FLAG" ) ):
add_action( "widgets_init", array( &$MANDATORY, "sidebar_widgets" ) );
add_action( "wp_footer", array( &$MANDATORY, "footer" ) );
add_action( "wp_print_scripts", array( &$MANDATORY, "wp_enqueue_scripts" ) );
add_action( "wp_print_styles", array( &$MANDATORY, "wp_enqueue_styles" ) );
endif;
?>