<?php /* TEMPLATE NAME: EVENTS  */ ?>
<?php get_header( ); ?>

<!-- /////////////////// MAIN CONTENT \\\\\\\\\\\\\\\\\\\\\-->          

<div class="row">
	
	<?php echo @$MPWP->get_hot_topics( ); ?>
	
	<section class="col-md-8 no_padding event_section_wrapper">
		<?php
		if ( have_posts( ) ) :
			the_post( ); ?>
			<h1><?php the_title( ); ?></h1>
			<?php
			the_content( );
		endif;
		$today = date( 'Y-m-d H:i:s' );
		$args = array(
			'category_name' => @$MPWP->categories['events'],
			'paged'			=> $paged,
			'orderby'		=> 'meta_value',
			'meta_key'		=> 'cpc_event_date',
			'order'			=> 'ASC',
			'meta_query'	=> array( 
				array(
					'key'		=> 'cpc_event_date', 
					'value'		=> $today,
					'type'		=> 'CHAR',
					'compare'	=> '>='
				)
			)
		);
		$lang = @q8_translate( 'en', 'fr');
		$query = new WP_Query( $args );
		while ( $query->have_posts( ) ) :
			$query->the_post(); 
			$cpc_event_date = strtotime( get_post_meta( $query->post->ID, 'cpc_event_date', true ) );
			$month = @$MPWP->get_month( date( 'M', $cpc_event_date ) );
			$month_fr = @$MPWP->get_month( date( 'm', $cpc_event_date ) );
			$day = date( 'd', $cpc_event_date );
			$cpc_event_time = strtotime( get_post_meta( $query->post->ID, 'cpc_event_time', true ) );
			$time = date( 'G:i', $cpc_event_time );
			$this_event_location = get_post_meta( $query->post->ID ,"cpc_event_location_".$lang , true );
			$event_location = ( $this_event_location ) ? $this_event_location : NULL;
			$event_location_map = get_post_meta( $query->post->ID, 'cpc_event_location_map', true );
			$event_location_map_embed = get_post_meta( $query->post->ID, 'cpc_event_location_map_embed', true );
			$link = get_permalink( );
			$img = @$MPWP->get_news_image( $query->post->ID );
			?>
			<article class="event_item_wrapper no_padding border bg">
				<header class="event_title_wrapper">
					<time class="event_date">
						<?php
						echo @q8_translate( '
						<span class="event_month">' . $month . '</span><br >
						<span class="event_day">' . $day . '</span>
						',
						'
						<span class="event_day">' . $day . '</span><br >
						<span class="event_month">' . $month_fr . '</span>
						'
						);
						?>
					</time>
					<h1 class="normal"><a href="<?php the_permalink( ); ?>" title="<?php the_title_attribute( ); ?>"><?php the_title( ); ?></a></h1>
					<time class="event_time"><?php echo $time ?></time>
					<?php if( $this_event_location ) { ?>
						<span class="event_location"><?php echo $this_event_location; ?></span>
						<?php if( $event_location_map ) { ?>
							<a href="<?php echo $event_location_map ?>" title="Map" class="more" target="_blank"><?php echo @q8_translate( "Map", "Carte" ); ?></a></span>
						<?php } // End if map link exists ?> 
					<?php } // End if address exists ?>
				</header>
				<?php echo $img ?>
				<?php the_excerpt( ); ?>
				<?php if ( trim( $event_location_map_embed ) ) { ?>
					<div class="gMaps">
						 <?php echo ( $event_location_map_embed );?>
					</div>
				<?php } ?>
				<?php echo @$MPWP->get_socialtools( $link,true ); ?>
			</article> <!-- event_item_wrapper no_padding border bg -->
		<?php endwhile;?>
			<ul class="pager"> 
				<li class="previous"><?php next_posts_link( '&larr; '.@q8_translate( "Older Events", " TRANSLATE" ), $query->max_num_pages ); ?></li>
				<li class="next"><?php previous_posts_link( @q8_translate( "Newer Events", "TRANSLATE" ).' &rarr;', $query->max_num_pages ); ?></li>
			</ul>
			<?php wp_reset_postdata( ); ?>
		</section><!-- col-md-8 no_padding event_section_wrapper -->
	<?php get_sidebar( ); ?>
	</div><!-- #subpage -->
<hr>
<?php get_footer( ); ?>